#ifndef __VECTOR_H__
#define __VECTOR_H__

typedef struct Vector Vector;

struct Vector {
	float x;
	float y;
	float z;
};

Vector Vector_withValues(float x, float y, float z);

void Vector_normalize(Vector * vector);
Vector Vector_normalized(Vector vector);

float Vector_magnitude(Vector vector);
float Vector_magnitudeSquared(Vector vector);
Vector Vector_add(Vector vector1, Vector vector2);
Vector Vector_subtract(Vector vector1, Vector vector2);
float Vector_dot(Vector vector1, Vector vector2);
Vector Vector_cross(Vector vector1, Vector vector2);

#endif
